-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: arabhost_myclients
-- ------------------------------------------------------
-- Server version	10.6.16-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `arabhost_myclients`
--


--
-- Table structure for table `altuseremail`
--

DROP TABLE IF EXISTS `altuseremail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `altuseremail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT 0,
  `email` varchar(50) NOT NULL DEFAULT '',
  `sendnotifications` tinyint(4) NOT NULL DEFAULT 1,
  `sendinvoice` tinyint(4) NOT NULL DEFAULT 1,
  `sendsupport` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcement`
--

DROP TABLE IF EXISTS `announcement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(125) NOT NULL DEFAULT '',
  `excerpt` text NOT NULL,
  `post` longtext NOT NULL,
  `postdate` datetime DEFAULT '0000-00-00 00:00:00',
  `publish` tinyint(4) NOT NULL DEFAULT 0,
  `authorid` int(11) NOT NULL DEFAULT 0,
  `recipient` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcement_recipient`
--

DROP TABLE IF EXISTS `announcement_recipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcement_recipient` (
  `ann_id` int(11) NOT NULL,
  `recipient_id` int(11) NOT NULL,
  PRIMARY KEY (`ann_id`,`recipient_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `autoresponders`
--

DROP TABLE IF EXISTS `autoresponders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autoresponders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT 1,
  `name` varchar(75) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `contents` text NOT NULL,
  `contents_html` text NOT NULL,
  `helpid` int(3) NOT NULL DEFAULT 0,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `billingtype`
--

DROP TABLE IF EXISTS `billingtype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billingtype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `detail` text NOT NULL,
  `price` varchar(10) NOT NULL DEFAULT '0.00',
  `archived` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `cachekey` varchar(50) NOT NULL DEFAULT '',
  `lastupdated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` mediumblob NOT NULL,
  PRIMARY KEY (`cachekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `clients_notes`
--

DROP TABLE IF EXISTS `clients_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `target_id` int(11) NOT NULL,
  `is_target_group` tinyint(4) NOT NULL DEFAULT 0,
  `admin_id` int(11) NOT NULL,
  `note` text NOT NULL,
  `visible_client` tinyint(4) NOT NULL,
  `archived` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `clients_notes_tickettypes`
--

DROP TABLE IF EXISTS `clients_notes_tickettypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients_notes_tickettypes` (
  `note_id` int(11) NOT NULL,
  `tickettype_id` int(11) NOT NULL,
  PRIMARY KEY (`note_id`,`tickettype_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `conversation`
--

DROP TABLE IF EXISTS `conversation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `conversation_messages`
--

DROP TABLE IF EXISTS `conversation_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversation_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sent_time` datetime NOT NULL,
  `message` mediumtext NOT NULL,
  `event` int(11) DEFAULT NULL,
  KEY `id` (`id`),
  KEY `conversation_id` (`conversation_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `conversation_participants`
--

DROP TABLE IF EXISTS `conversation_participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversation_participants` (
  `conversation_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `read_time` datetime NOT NULL,
  `active` tinyint(4) NOT NULL,
  `typing` tinyint(4) NOT NULL,
  `color` varchar(25) NOT NULL DEFAULT 'black',
  PRIMARY KEY (`conversation_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country`
--

DROP TABLE IF EXISTS `country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL DEFAULT '',
  `iso` char(2) NOT NULL DEFAULT '',
  `phone_code` varchar(10) NOT NULL DEFAULT '',
  `exists` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `by_name` (`name`,`iso`),
  KEY `by_iso` (`iso`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `coupons`
--

DROP TABLE IF EXISTS `coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupons` (
  `coupons_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_name` varchar(50) NOT NULL DEFAULT '',
  `coupons_description` text NOT NULL,
  `coupons_code` varchar(50) NOT NULL DEFAULT '',
  `coupons_quantity` int(11) NOT NULL DEFAULT 0,
  `coupons_type` tinyint(4) NOT NULL DEFAULT 0,
  `coupons_applicable_to` tinyint(4) NOT NULL DEFAULT 127,
  `coupons_discount` float(23,2) NOT NULL DEFAULT 0.00,
  `coupons_start` date NOT NULL DEFAULT '0000-00-00',
  `coupons_expires` date NOT NULL DEFAULT '0000-00-00',
  `coupons_recurring` tinyint(4) NOT NULL DEFAULT 0,
  `coupons_recurringmonths` tinyint(4) NOT NULL DEFAULT 0,
  `coupons_billingcycles` tinyint(4) NOT NULL DEFAULT 0,
  `coupons_archive` tinyint(1) NOT NULL DEFAULT 0,
  `coupons_taxable` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`coupons_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `coupons_packages`
--

DROP TABLE IF EXISTS `coupons_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupons_packages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_id` int(11) NOT NULL DEFAULT 0,
  `promotion_id` int(11) NOT NULL DEFAULT 0,
  `package_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `coupons_usage`
--

DROP TABLE IF EXISTS `coupons_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupons_usage` (
  `invoiceentryid` int(11) NOT NULL,
  `couponid` int(11) NOT NULL,
  `isrecurring` tinyint(1) NOT NULL,
  PRIMARY KEY (`invoiceentryid`,`couponid`,`isrecurring`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL DEFAULT '',
  `symbol` char(10) NOT NULL DEFAULT '',
  `abrv` varchar(4) NOT NULL DEFAULT '',
  `alignment` varchar(10) NOT NULL DEFAULT 'left',
  `precision` int(1) NOT NULL DEFAULT 2,
  `rate` float(23,10) NOT NULL DEFAULT 1.0000000000,
  `enabled` tinyint(4) NOT NULL DEFAULT 1,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customField`
--

DROP TABLE IF EXISTS `customField`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customField` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` tinyint(4) NOT NULL DEFAULT 0,
  `subGroupId` tinyint(4) NOT NULL DEFAULT 0,
  `fieldType` tinyint(4) NOT NULL DEFAULT 0,
  `name` varchar(50) NOT NULL DEFAULT '',
  `isRequired` tinyint(4) NOT NULL DEFAULT 0,
  `isChangeable` tinyint(4) NOT NULL DEFAULT 1,
  `isAdminOnly` tinyint(4) NOT NULL DEFAULT 0,
  `fieldOrder` int(11) NOT NULL DEFAULT 0,
  `showCustomer` tinyint(4) NOT NULL DEFAULT 1,
  `showAdmin` tinyint(4) NOT NULL DEFAULT 1,
  `dropDownOptions` longtext NOT NULL,
  `inSettings` smallint(6) NOT NULL DEFAULT 1,
  `InSignup` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customuserfields`
--

DROP TABLE IF EXISTS `customuserfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customuserfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `isrequired` tinyint(4) NOT NULL DEFAULT 0,
  `isChangable` tinyint(4) NOT NULL DEFAULT 1,
  `isAdminOnly` tinyint(4) NOT NULL DEFAULT 0,
  `width` mediumint(9) NOT NULL DEFAULT 20,
  `myOrder` int(11) NOT NULL DEFAULT 0,
  `showcustomer` tinyint(4) NOT NULL DEFAULT 1,
  `showadmin` tinyint(4) NOT NULL DEFAULT 1,
  `InSignup` tinyint(1) NOT NULL DEFAULT 0,
  `inSettings` smallint(6) NOT NULL DEFAULT 1,
  `dropdownoptions` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `departments`
--

DROP TABLE IF EXISTS `departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `is_generaldep` tinyint(4) NOT NULL DEFAULT 0,
  `lead_id` int(11) NOT NULL,
  `emails_to_notify` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `departments_members`
--

DROP TABLE IF EXISTS `departments_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `departments_members` (
  `department_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `is_group` tinyint(4) NOT NULL,
  `assign_to` tinyint(4) NOT NULL DEFAULT 0,
  `notify_to` tinyint(4) NOT NULL DEFAULT 0,
  `sendclosed` int(2) NOT NULL DEFAULT 0,
  `sendfeedback` int(2) NOT NULL DEFAULT 0,
  `sendresolution` int(2) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `domain_packageaddon_prices`
--

DROP TABLE IF EXISTS `domain_packageaddon_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `domain_packageaddon_prices` (
  `domain_id` int(11) NOT NULL DEFAULT 0,
  `packageaddon_prices_id` int(11) NOT NULL DEFAULT 0,
  `billing_cycle` tinyint(4) NOT NULL DEFAULT 0,
  `nextbilldate` date DEFAULT NULL,
  PRIMARY KEY (`domain_id`,`packageaddon_prices_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `domains`
--

DROP TABLE IF EXISTS `domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `DomainName` text DEFAULT NULL,
  `CustomerID` int(11) DEFAULT NULL,
  `UserName` text DEFAULT NULL,
  `password` tinyblob NOT NULL,
  `registration_years` tinyint(4) NOT NULL DEFAULT 0,
  `current` tinyint(4) NOT NULL DEFAULT 1,
  `registrar_orderid` varchar(50) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `Plan` int(11) NOT NULL DEFAULT 0,
  `dateActivated` datetime DEFAULT NULL,
  `controlpanel` int(11) NOT NULL DEFAULT 0,
  `serverid` int(11) NOT NULL DEFAULT 0,
  `server_acct_properties` text DEFAULT NULL,
  `domain_extra_attr` text DEFAULT NULL,
  `shared` tinyint(4) NOT NULL DEFAULT 1,
  `promotionid` int(11) NOT NULL DEFAULT 0,
  `register` tinyint(4) NOT NULL DEFAULT 0,
  `signup` tinyint(4) NOT NULL DEFAULT 0,
  `custom_price` float(23,2) NOT NULL DEFAULT 0.00,
  `use_custom_price` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `CustomerID` (`CustomerID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `email_queue`
--

DROP TABLE IF EXISTS `email_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `from` varchar(50) NOT NULL DEFAULT '',
  `from_name` varchar(50) NOT NULL DEFAULT '',
  `bcc` text NOT NULL,
  `priority` tinyint(4) NOT NULL DEFAULT 0,
  `confirmreceipt` tinyint(4) NOT NULL DEFAULT 0,
  `emailtype` varchar(50) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `contenttype` tinyint(4) NOT NULL DEFAULT 0,
  `dfilename` varchar(50) NOT NULL DEFAULT '',
  `attachment` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `email_queue_addressees`
--

DROP TABLE IF EXISTS `email_queue_addressees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_queue_addressees` (
  `email_queue_id` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`email_queue_id`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `escalationrules`
--

DROP TABLE IF EXISTS `escalationrules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `escalationrules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `time_elapsed` int(11) NOT NULL,
  `ticket_status` tinyint(4) NOT NULL,
  `ticket_priority` tinyint(4) NOT NULL,
  `ticket_tag` varchar(10) NOT NULL,
  `reassign_dept` int(11) NOT NULL,
  `reassign_staff` int(11) NOT NULL,
  `new_priority` tinyint(4) NOT NULL,
  `new_tag` varchar(10) NOT NULL,
  `only_apply_once` tinyint(4) NOT NULL,
  `transcription_destinataries` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `escalationrules_departments`
--

DROP TABLE IF EXISTS `escalationrules_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `escalationrules_departments` (
  `escalationrule_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  PRIMARY KEY (`escalationrule_id`,`department_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `events_log`
--

DROP TABLE IF EXISTS `events_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `events_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `user_id` int(11) NOT NULL,
  `entity_type` varchar(50) NOT NULL,
  `entity_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `subject` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files` (
  `id_file` int(11) NOT NULL AUTO_INCREMENT,
  `id_cat` int(11) DEFAULT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL DEFAULT '',
  `hash` varchar(16) NOT NULL DEFAULT '',
  `visible` int(11) NOT NULL DEFAULT 0,
  `public` int(11) NOT NULL DEFAULT 0,
  `size` int(11) NOT NULL DEFAULT 0,
  `added` date NOT NULL DEFAULT '0000-00-00',
  `downloads` int(11) NOT NULL DEFAULT 0,
  `lastip` varchar(15) NOT NULL DEFAULT '',
  `notes` text NOT NULL,
  `user_status` set('-3','-2','-1','0','1') NOT NULL,
  PRIMARY KEY (`id_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_cats`
--

DROP TABLE IF EXISTS `files_cats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_cats` (
  `id_cat` int(11) NOT NULL AUTO_INCREMENT,
  `id_parent` int(11) DEFAULT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `visible` int(11) NOT NULL DEFAULT 0,
  `public` int(11) NOT NULL DEFAULT 0,
  `user_status` set('-3','-2','-1','0','1') NOT NULL,
  PRIMARY KEY (`id_cat`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_cats_clienttypes`
--

DROP TABLE IF EXISTS `files_cats_clienttypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_cats_clienttypes` (
  `id_cat` int(11) NOT NULL DEFAULT 0,
  `id_clienttype` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_cat`,`id_clienttype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_cats_servers`
--

DROP TABLE IF EXISTS `files_cats_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_cats_servers` (
  `id_cat` int(11) NOT NULL DEFAULT 0,
  `id_server` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_cat`,`id_server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_cats_users`
--

DROP TABLE IF EXISTS `files_cats_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_cats_users` (
  `id_cat` int(11) NOT NULL DEFAULT 0,
  `id_user` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_cat`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_clienttypes`
--

DROP TABLE IF EXISTS `files_clienttypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_clienttypes` (
  `id_file` int(11) NOT NULL DEFAULT 0,
  `id_clienttype` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_file`,`id_clienttype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_servers`
--

DROP TABLE IF EXISTS `files_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_servers` (
  `id_file` int(11) NOT NULL DEFAULT 0,
  `id_server` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_file`,`id_server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `files_users`
--

DROP TABLE IF EXISTS `files_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files_users` (
  `id_file` int(11) NOT NULL DEFAULT 0,
  `id_user` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_file`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `isadmin` tinyint(4) NOT NULL DEFAULT 1,
  `issuperadmin` tinyint(4) NOT NULL DEFAULT 0,
  `description` text NOT NULL,
  `usedefaultcolor` tinyint(4) NOT NULL DEFAULT 1,
  `groupcolor` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `help`
--

DROP TABLE IF EXISTS `help`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(40) NOT NULL DEFAULT '',
  `detail` text NOT NULL,
  `linkwords` varchar(40) NOT NULL DEFAULT 'Click to view available tags',
  `width` int(3) NOT NULL DEFAULT 240,
  `height` int(3) NOT NULL DEFAULT 320,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoice`
--

DROP TABLE IF EXISTS `invoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` int(11) NOT NULL DEFAULT 0,
  `billdate` date NOT NULL DEFAULT '0000-00-00',
  `description` varchar(50) NOT NULL DEFAULT '',
  `amount` float(23,2) NOT NULL DEFAULT 0.00,
  `subtotal` float(23,2) NOT NULL DEFAULT 0.00,
  `balance_due` float(23,2) NOT NULL DEFAULT 0.00,
  `sent` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `archive` tinyint(4) NOT NULL DEFAULT 0,
  `sentdate` date DEFAULT NULL,
  `datepaid` date DEFAULT NULL,
  `tax` float(23,2) NOT NULL DEFAULT 0.00,
  `taxname` varchar(20) NOT NULL DEFAULT '',
  `tax2` float(23,2) NOT NULL DEFAULT 0.00,
  `tax2name` varchar(20) NOT NULL DEFAULT '',
  `tax2compound` tinyint(4) NOT NULL DEFAULT 0,
  `processorid` varchar(255) NOT NULL DEFAULT '',
  `pluginused` varchar(15) NOT NULL DEFAULT 'none',
  `checknum` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `customerid` (`customerid`)
) ENGINE=MyISAM AUTO_INCREMENT=25101975 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoiceentry`
--

DROP TABLE IF EXISTS `invoiceentry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoiceentry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` int(11) NOT NULL DEFAULT 0,
  `description` varchar(95) NOT NULL DEFAULT '',
  `detail` text NOT NULL,
  `invoiceid` int(11) NOT NULL DEFAULT 0,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `billingtypeid` int(11) NOT NULL DEFAULT 0,
  `is_prorating` tinyint(4) NOT NULL DEFAULT 0,
  `price` float(23,2) NOT NULL DEFAULT 0.00,
  `price_percent` float(23,2) NOT NULL DEFAULT 0.00,
  `recurring` int(11) NOT NULL DEFAULT 0,
  `recurringappliesto` int(11) DEFAULT 0,
  `appliestoid` int(11) NOT NULL DEFAULT 0,
  `coupon_applicable_to` tinyint(4) NOT NULL DEFAULT 0,
  `includenextpayment` tinyint(4) NOT NULL DEFAULT 0,
  `paymentterm` tinyint(4) NOT NULL DEFAULT 0,
  `setup` tinyint(4) NOT NULL DEFAULT 0,
  `addon_setup` tinyint(4) NOT NULL DEFAULT 0,
  `taxable` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci COMMENT='Maintain information of work completed for customer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoicetransaction`
--

DROP TABLE IF EXISTS `invoicetransaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoicetransaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoiceid` int(11) NOT NULL DEFAULT 0,
  `accepted` tinyint(4) NOT NULL DEFAULT 0,
  `response` text NOT NULL,
  `transactiondate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `transactionid` varchar(100) NOT NULL DEFAULT 'NA',
  `action` varchar(10) NOT NULL DEFAULT 'none',
  `last4` varchar(5) NOT NULL DEFAULT '0000',
  `amount` float(23,2) DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles`
--

DROP TABLE IF EXISTS `kb_articles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `excerpt` text NOT NULL,
  `content` text NOT NULL,
  `author` varchar(250) NOT NULL,
  `publisher` int(11) NOT NULL,
  `is_draft` tinyint(4) NOT NULL DEFAULT 0,
  `access` tinyint(4) NOT NULL DEFAULT 0,
  `is_ticket_summary` tinyint(4) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_user_id` int(11) NOT NULL,
  `rating` float(7,2) NOT NULL DEFAULT 0.00,
  `ratingvisitors` int(11) NOT NULL DEFAULT 0,
  `totalvisitors` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `title` (`title`,`excerpt`,`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles_categories`
--

DROP TABLE IF EXISTS `kb_articles_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles_categories` (
  `articleid` int(11) NOT NULL,
  `categoryid` int(11) NOT NULL,
  PRIMARY KEY (`articleid`,`categoryid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles_comments`
--

DROP TABLE IF EXISTS `kb_articles_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles_comments` (
  `articleid` varchar(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `added` datetime NOT NULL,
  `email` varchar(250) NOT NULL,
  `comment` text NOT NULL,
  `is_approved` tinyint(4) NOT NULL DEFAULT 0,
  `is_internal` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`articleid`,`username`,`added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles_files`
--

DROP TABLE IF EXISTS `kb_articles_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `articleid` int(11) NOT NULL,
  `filename` varchar(50) NOT NULL,
  `dateadded` datetime NOT NULL,
  `filekey` varchar(16) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `filekey` (`filekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles_rate`
--

DROP TABLE IF EXISTS `kb_articles_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles_rate` (
  `articleid` int(11) NOT NULL,
  `used_ips` varchar(32) NOT NULL,
  PRIMARY KEY (`articleid`,`used_ips`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles_tickettypes`
--

DROP TABLE IF EXISTS `kb_articles_tickettypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles_tickettypes` (
  `article_id` int(11) NOT NULL,
  `tickettype_id` int(11) NOT NULL,
  PRIMARY KEY (`article_id`,`tickettype_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articles_views`
--

DROP TABLE IF EXISTS `kb_articles_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articles_views` (
  `articleid` int(11) NOT NULL,
  `userid` varchar(11) NOT NULL,
  `ip` varchar(100) NOT NULL,
  PRIMARY KEY (`articleid`,`userid`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_articlesrelated`
--

DROP TABLE IF EXISTS `kb_articlesrelated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_articlesrelated` (
  `articleid` int(11) NOT NULL,
  `relatedid` int(11) NOT NULL,
  PRIMARY KEY (`articleid`,`relatedid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kb_categories`
--

DROP TABLE IF EXISTS `kb_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kb_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `counter` int(11) NOT NULL DEFAULT 0,
  `staffonly` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `nameserver`
--

DROP TABLE IF EXISTS `nameserver`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nameserver` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serverid` int(11) NOT NULL DEFAULT 0,
  `ip` varchar(50) NOT NULL DEFAULT '',
  `hostname` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `object_customField`
--

DROP TABLE IF EXISTS `object_customField`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `object_customField` (
  `objectid` int(11) NOT NULL DEFAULT 0,
  `customFieldId` int(11) NOT NULL DEFAULT 0,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`objectid`,`customFieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package`
--

DROP TABLE IF EXISTS `package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `planname` varchar(45) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `planid` int(11) NOT NULL DEFAULT 0,
  `price` float(23,2) NOT NULL DEFAULT 0.00,
  `showpackage` smallint(6) NOT NULL DEFAULT 1,
  `price3` float(23,2) NOT NULL DEFAULT 0.00,
  `price6` float(23,2) NOT NULL DEFAULT 0.00,
  `price12` float(23,2) NOT NULL DEFAULT 0.00,
  `price24` float(23,2) NOT NULL DEFAULT 0.00,
  `price1included` tinyint(4) NOT NULL DEFAULT 1,
  `price3included` tinyint(4) NOT NULL DEFAULT 1,
  `price6included` tinyint(4) NOT NULL DEFAULT 1,
  `price12included` tinyint(4) NOT NULL DEFAULT 1,
  `price24included` tinyint(4) NOT NULL DEFAULT 1,
  `setup` float(23,2) NOT NULL DEFAULT 0.00,
  `usedefaultwelcome` tinyint(4) NOT NULL DEFAULT 1,
  `welcomeemail_text` text NOT NULL,
  `welcomeemail_html` text NOT NULL,
  `welcomeemail_subject` varchar(50) NOT NULL,
  `taxable` tinyint(4) NOT NULL DEFAULT 0,
  `style` tinyint(4) DEFAULT 0,
  `automaticactivation` tinyint(4) DEFAULT 1,
  `allowdirectlink` tinyint(4) DEFAULT 0,
  `sendwelcome` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package_server`
--

DROP TABLE IF EXISTS `package_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package_server` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT 0,
  `server_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package_tld`
--

DROP TABLE IF EXISTS `package_tld`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package_tld` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `package_id` int(11) unsigned NOT NULL DEFAULT 0,
  `tld_id` int(11) unsigned NOT NULL DEFAULT 0,
  `period` int(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package_variable`
--

DROP TABLE IF EXISTS `package_variable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package_variable` (
  `packageid` int(11) NOT NULL DEFAULT 0,
  `varname` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`packageid`,`varname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `packageaddon`
--

DROP TABLE IF EXISTS `packageaddon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packageaddon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `plugin_var` varchar(50) NOT NULL,
  `order` int(11) NOT NULL DEFAULT 0,
  `taxable` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `packageaddon_prices`
--

DROP TABLE IF EXISTS `packageaddon_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packageaddon_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `packageaddon_id` int(11) NOT NULL DEFAULT 0,
  `sortkey` int(11) NOT NULL DEFAULT 0,
  `detail` varchar(50) NOT NULL DEFAULT '',
  `plugin_var_value` varchar(50) NOT NULL DEFAULT '',
  `price0` float(23,2) NOT NULL DEFAULT -1.00,
  `price1` float(23,2) NOT NULL DEFAULT -1.00,
  `price1_force` smallint(6) NOT NULL DEFAULT 0,
  `price3` float(23,2) NOT NULL DEFAULT -1.00,
  `price3_force` smallint(6) NOT NULL DEFAULT 0,
  `price6` float(23,2) NOT NULL DEFAULT -1.00,
  `price6_force` tinyint(4) NOT NULL DEFAULT 0,
  `price12` float(23,2) NOT NULL DEFAULT -1.00,
  `price12_force` tinyint(4) NOT NULL DEFAULT 0,
  `price24` float(23,2) NOT NULL DEFAULT -1.00,
  `price24_force` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `subject_id` int(11) NOT NULL DEFAULT 0,
  `is_group` tinyint(4) NOT NULL DEFAULT 0,
  `permission` varchar(100) NOT NULL DEFAULT '',
  `target_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`subject_id`,`is_group`,`permission`,`target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugin_custom_data`
--

DROP TABLE IF EXISTS `plugin_custom_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `plugin_custom_data` (
  `name` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `plugin_name` varchar(25) NOT NULL,
  `plugin_type` varchar(25) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`name`,`plugin_name`,`plugin_type`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `product_addon`
--

DROP TABLE IF EXISTS `product_addon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_addon` (
  `product_id` int(11) NOT NULL,
  `addon_id` int(11) NOT NULL,
  `order` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `productgroup_addon`
--

DROP TABLE IF EXISTS `productgroup_addon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productgroup_addon` (
  `productgroup_id` int(11) NOT NULL,
  `addon_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion`
--

DROP TABLE IF EXISTS `promotion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT 1,
  `showuser` tinyint(4) NOT NULL DEFAULT 1,
  `welcomeemail_text` text NOT NULL,
  `welcomeemail_html` text NOT NULL,
  `welcomeemail_subject` varchar(50) NOT NULL,
  `isdefault` smallint(1) NOT NULL DEFAULT 0,
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` smallint(1) NOT NULL DEFAULT 0,
  `issub` tinyint(4) NOT NULL DEFAULT 0,
  `maindomain` varchar(50) NOT NULL DEFAULT 'yourdomain.com',
  `allowreg` tinyint(4) NOT NULL DEFAULT 1,
  `allowtransfer` tinyint(4) NOT NULL DEFAULT 0,
  `allowselfmanage` tinyint(4) NOT NULL DEFAULT 1,
  `promorder` int(11) NOT NULL,
  `emailid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_customdomainfields`
--

DROP TABLE IF EXISTS `promotion_customdomainfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_customdomainfields` (
  `promotionid` int(11) NOT NULL,
  `customid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recurringfee`
--

DROP TABLE IF EXISTS `recurringfee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recurringfee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` int(11) NOT NULL DEFAULT 0,
  `billingtypeid` int(11) NOT NULL DEFAULT 0,
  `packageaddon_prices_id` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `amount` float(23,2) NOT NULL DEFAULT 0.00,
  `amount_percent` float(23,2) NOT NULL DEFAULT 0.00,
  `appliestoid` int(11) NOT NULL DEFAULT 0,
  `coupon_applicable_to` tinyint(4) NOT NULL DEFAULT 0,
  `nextbilldate` date DEFAULT NULL,
  `paymentterm` tinyint(4) DEFAULT NULL,
  `disablegenerate` tinyint(4) NOT NULL DEFAULT 0,
  `taxable` tinyint(4) NOT NULL DEFAULT 0,
  `monthlyusage` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `recurring` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `registrars`
--

DROP TABLE IF EXISTS `registrars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `registrars` (
  `plugin` varchar(20) NOT NULL,
  `tld` varchar(10) NOT NULL,
  `extra_attributes` text NOT NULL,
  PRIMARY KEY (`plugin`,`tld`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report`
--

DROP TABLE IF EXISTS `report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `report` (
  `name` varchar(80) NOT NULL,
  `public` tinyint(4) NOT NULL DEFAULT 0,
  `quickgraph` tinyint(4) NOT NULL DEFAULT 0,
  `dashboard` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `routingrules`
--

DROP TABLE IF EXISTS `routingrules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `routingrules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `order` int(11) NOT NULL DEFAULT 0,
  `emails` text NOT NULL,
  `user_type` tinyint(4) NOT NULL,
  `autoresponder_template` int(11) NOT NULL,
  `openticket` tinyint(4) NOT NULL DEFAULT 0,
  `target_type` int(11) NOT NULL,
  `target_priority` int(11) NOT NULL,
  `target_dept` int(11) NOT NULL,
  `target_staff` int(11) NOT NULL,
  `copy_destinataries` text NOT NULL,
  `routing_type` tinyint(4) NOT NULL,
  `filter_out` text NOT NULL,
  `pop3_hostname` varchar(50) NOT NULL,
  `pop3_port` varchar(4) NOT NULL,
  `pop3_username` varchar(50) NOT NULL,
  `pop3_password` varchar(50) NOT NULL,
  `pop3_delete_emails` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `routingrules_groups`
--

DROP TABLE IF EXISTS `routingrules_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `routingrules_groups` (
  `routingrule_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`routingrule_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `server`
--

DROP TABLE IF EXISTS `server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `server` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `hostname` varchar(50) NOT NULL DEFAULT '',
  `sharedip` varchar(50) NOT NULL DEFAULT '',
  `isdefault` tinyint(1) NOT NULL DEFAULT 0,
  `plugin` varchar(25) NOT NULL DEFAULT '',
  `last_utilization` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `domains_quota` int(11) NOT NULL DEFAULT 0,
  `statsurl` varchar(225) NOT NULL,
  `statsviewable` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `serverip`
--

DROP TABLE IF EXISTS `serverip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `serverip` (
  `serverid` int(11) NOT NULL DEFAULT 0,
  `ip` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `serverplugin_options`
--

DROP TABLE IF EXISTS `serverplugin_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `serverplugin_options` (
  `serverid` int(11) NOT NULL DEFAULT 0,
  `optionname` varchar(125) NOT NULL DEFAULT '',
  `value` longblob NOT NULL,
  PRIMARY KEY (`serverid`,`optionname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `services_log`
--

DROP TABLE IF EXISTS `services_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `services_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) NOT NULL DEFAULT '',
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `manually_executed` smallint(6) NOT NULL DEFAULT 0,
  `results` text NOT NULL,
  `errors` text NOT NULL,
  `status` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `setting`
--

DROP TABLE IF EXISTS `setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `value` text NOT NULL,
  `value_alternate` text DEFAULT NULL,
  `description` text NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `isrequired` tinyint(4) NOT NULL DEFAULT 1,
  `istruefalse` tinyint(4) NOT NULL DEFAULT 0,
  `istextarea` tinyint(4) NOT NULL DEFAULT 0,
  `issmalltextarea` tinyint(4) NOT NULL DEFAULT 0,
  `isfromoptions` tinyint(4) NOT NULL DEFAULT 0,
  `myorder` int(11) NOT NULL DEFAULT 0,
  `helpid` int(3) DEFAULT 0,
  `plugin` tinyint(4) NOT NULL DEFAULT 0,
  `ispassword` tinyint(4) NOT NULL DEFAULT 0,
  `ishidden` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`),
  KEY `plugin` (`plugin`)
) ENGINE=MyISAM AUTO_INCREMENT=918 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `setting_options`
--

DROP TABLE IF EXISTS `setting_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `setting_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `settingid` int(11) NOT NULL DEFAULT 0,
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci COMMENT='Contains all the available options for a giving setting';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxrule`
--

DROP TABLE IF EXISTS `taxrule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxrule` (
  `countrycode` varchar(5) NOT NULL DEFAULT '',
  `state` varchar(20) NOT NULL DEFAULT '',
  `tax` float(23,2) NOT NULL DEFAULT 0.00,
  `vat` tinyint(4) NOT NULL DEFAULT 0,
  `name` varchar(20) NOT NULL DEFAULT '',
  `level` tinyint(4) NOT NULL DEFAULT 1,
  `compound` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`countrycode`,`state`,`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `team_status`
--

DROP TABLE IF EXISTS `team_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `team_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `userstatus` text NOT NULL,
  `status_datetime` datetime NOT NULL,
  `replyid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `team_status_follow`
--

DROP TABLE IF EXISTS `team_status_follow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `team_status_follow` (
  `userid` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  UNIQUE KEY `userid` (`userid`,`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tld`
--

DROP TABLE IF EXISTS `tld`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tld` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '',
  `plugin` varchar(25) NOT NULL DEFAULT '',
  `pricing` text NOT NULL,
  `active` smallint(1) NOT NULL DEFAULT 1,
  `dnsmgmt` smallint(1) NOT NULL,
  `autorenew` smallint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket`
--

DROP TABLE IF EXISTS `troubleticket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT 0,
  `domainid` int(11) DEFAULT 0,
  `subject` text NOT NULL,
  `priority` int(2) NOT NULL DEFAULT 3,
  `support_email` varchar(60) DEFAULT NULL,
  `datesubmitted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` int(2) NOT NULL DEFAULT 0,
  `messagetype` int(11) NOT NULL DEFAULT 0,
  `assignedtoid` int(11) NOT NULL DEFAULT 0,
  `assignedtodeptid` int(11) NOT NULL DEFAULT 0,
  `lastlog_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rate_hash` char(32) DEFAULT NULL,
  `rate` tinyint(4) NOT NULL DEFAULT 0,
  `feedback` text DEFAULT NULL,
  `autoclose` int(2) NOT NULL DEFAULT 0,
  `tag` varchar(10) NOT NULL DEFAULT 'clear',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `subject` (`subject`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket_additionalnotification`
--

DROP TABLE IF EXISTS `troubleticket_additionalnotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket_additionalnotification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticketid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticketid` (`ticketid`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket_escalated`
--

DROP TABLE IF EXISTS `troubleticket_escalated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket_escalated` (
  `ticket_id` int(11) NOT NULL,
  `escalationrule_id` int(11) NOT NULL,
  PRIMARY KEY (`ticket_id`,`escalationrule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket_files`
--

DROP TABLE IF EXISTS `troubleticket_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticketid` int(11) NOT NULL,
  `filename` varchar(50) NOT NULL,
  `dateadded` datetime NOT NULL,
  `filekey` varchar(16) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `filekey` (`filekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket_filters`
--

DROP TABLE IF EXISTS `troubleticket_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket_filters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL DEFAULT 0,
  `private` int(2) NOT NULL DEFAULT 0,
  `temp` tinyint(4) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `lastlog_datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket_log`
--

DROP TABLE IF EXISTS `troubleticket_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `troubleticketid` int(11) NOT NULL DEFAULT 0,
  `message` text NOT NULL,
  `userid` int(11) NOT NULL DEFAULT 0,
  `externalemail` tinyint(4) NOT NULL DEFAULT 0,
  `mydatetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logaction` tinyint(4) NOT NULL DEFAULT 0,
  `private` int(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `message` (`message`),
  FULLTEXT KEY `message_2` (`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `troubleticket_type`
--

DROP TABLE IF EXISTS `troubleticket_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `troubleticket_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `myorder` int(2) NOT NULL DEFAULT 0,
  `enabled` tinyint(4) NOT NULL DEFAULT 1,
  `enabled_public` tinyint(4) NOT NULL DEFAULT 1,
  `is_billing_type` tinyint(4) NOT NULL DEFAULT 0,
  `target_dept` int(11) NOT NULL,
  `target_staff` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userPackage`
--

DROP TABLE IF EXISTS `userPackage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userPackage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `productGroupId` int(11) NOT NULL DEFAULT 0,
  `productId` int(11) NOT NULL DEFAULT 0,
  `useCustomPrice` tinyint(4) NOT NULL DEFAULT 0,
  `customPrice` float(23,2) NOT NULL DEFAULT 0.00,
  `dateActivated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_customuserfields`
--

DROP TABLE IF EXISTS `user_customuserfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_customuserfields` (
  `userid` int(11) NOT NULL DEFAULT 0,
  `customid` int(11) NOT NULL DEFAULT 0,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`userid`,`customid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_groups`
--

DROP TABLE IF EXISTS `user_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_groups` (
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `current` tinyint(1) DEFAULT 1,
  `paymenttype` varchar(30) NOT NULL DEFAULT '0',
  `clienttype` tinyint(4) NOT NULL DEFAULT 0,
  `groupid` int(10) DEFAULT 1,
  `password` varchar(45) DEFAULT NULL,
  `dateActivated` date DEFAULT NULL,
  `signature_text` text DEFAULT NULL,
  `signature_html` text DEFAULT NULL,
  `lastlogin` datetime DEFAULT NULL,
  `lastseen` datetime DEFAULT NULL,
  `isOrganization` tinyint(4) DEFAULT 0,
  `active` smallint(6) NOT NULL DEFAULT 1,
  `recurring` tinyint(4) DEFAULT 1,
  `currency` varchar(5) DEFAULT '0',
  `data1` text DEFAULT NULL,
  `autopayment` smallint(1) NOT NULL DEFAULT 0,
  `ccmonth` varchar(4) NOT NULL DEFAULT '0',
  `ccyear` varchar(4) NOT NULL DEFAULT '0',
  `cclastfour` varchar(5) NOT NULL DEFAULT '',
  `data2` text DEFAULT NULL,
  `data3` text DEFAULT NULL,
  `passphrased` smallint(1) NOT NULL DEFAULT 0,
  `updating` tinyint(4) NOT NULL DEFAULT 0,
  `taxable` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `firstname` varchar(25) NOT NULL DEFAULT '',
  `lastname` varchar(25) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `organization` varchar(60) NOT NULL DEFAULT '',
  `usernotes` longtext DEFAULT NULL,
  `usernotespos` varchar(75) NOT NULL DEFAULT '',
  `warningmask` int(11) NOT NULL DEFAULT 0,
  `balance` float(23,2) NOT NULL DEFAULT 0.00,
  `chatstatus` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users_domains`
--

DROP TABLE IF EXISTS `users_domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `domain` varchar(50) NOT NULL,
  `period` int(11) NOT NULL,
  `auto_renew` tinyint(4) NOT NULL DEFAULT 1,
  `nextbilldate` date NOT NULL,
  `domain_extra_attr` text DEFAULT NULL,
  `registration_option` tinyint(4) NOT NULL,
  `registrar` varchar(20) NOT NULL,
  `registrar_orderid` varchar(50) NOT NULL,
  `status` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `versions`
--

DROP TABLE IF EXISTS `versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `versions` (
  `module` varchar(50) NOT NULL,
  `version` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping events for database 'arabhost_myclients'
--

--
-- Dumping routines for database 'arabhost_myclients'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-11-24 20:08:22
